import 'package:flutter/material.dart';
import 'package:flutter_remix/flutter_remix.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:lottie/lottie.dart';

import '../../../presentation/app_assets.dart';
import '../styles/style.dart';

class CustomRefresher extends StatelessWidget {
  final VoidCallback onTap;
  final bool isLoading;

  const CustomRefresher(
      {super.key, required this.onTap, required this.isLoading});

  @override
  Widget build(BuildContext context) {
    return InkWell(
        borderRadius: BorderRadius.circular(10.r),
        onTap: onTap,
        child: Container(
          height: 52.r,
          width: 52.r,
          decoration: BoxDecoration(
              color: Style.white,
              borderRadius: BorderRadiusDirectional.circular(10.r)),
          child: Center(
            child: isLoading
                ? Lottie.asset(
                    Assets.lottieRefresh,
                    width: 36.r,
                    height: 36.r,
                    fit: BoxFit.fill,
                  )
                : Icon(
                    FlutterRemix.refresh_line,
                    size: 26.r,
                  ),
          ),
        ),
    );
  }
}
